#include <bits/stdc++.h>
// #pragma comment(linker, "/STACK:16777216")
// #pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,sse4,fma,bmi,bmi2,popcnt,lzcnt,abm")

using std::cin;
using std::cout;
using std::map;
using std::pair;
using std::set;
using std::string;
using std::unordered_map;
using std::unordered_set;
using std::vector;

using uint = unsigned int;
using ll = long long;
using ull = unsigned long long;
using dbl = double;
using ld = long double;
using pii = pair<int, int>;
using pll = pair<ll, ll>;
using pdd = pair<dbl, dbl>;
using pld = pair<ld, ld>;

// #include <ext/pb_ds/assoc_container.hpp>
// #include <ext/pb_ds/tree_policy.hpp>
// using namespace __gnu_pbds;
// typedef tree<int, null_type, less<>, rb_tree_tag, tree_order_statistics_node_update> ordered_set;

#define ft first
#define sc second
#define pb push_back
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()

struct segtree {
    int sz = 1;
    vector<int> tree;

    segtree(int n) {
        while (sz < n) sz <<= 1;
        tree.resize(2 * sz);
    }

    void update(int x, int i) {
        i += sz;
        tree[i] += x;
        i /= 2;
        while (i > 0) {
            tree[i] = tree[2 * i] + tree[2 * i + 1];
            i /= 2;
        }
    }

    int get(int l, int r, int lx, int rx, int node) {
        if (l >= rx || r <= lx) return 0;
        if (l <= lx && rx <= r) return tree[node];
        int mid = (lx + rx) / 2;
        int get1 = get(l, r, lx, mid, node * 2);
        int get2 = get(l, r, mid, rx, node * 2 + 1);
        return get1 + get2;
    }
};

const int MAXN = 2e5 + 1;
const int B = 800;
static int smallT[B][B];  // second dim up to 2*T+1

inline int query_idx(int idx, segtree& st) {
    // idx is 0-based. Start with the base value a[idx].
    int ans = st.get(0, idx + 1, 0, st.sz, 1);
    // Add all “small-k” contributions: if (idx % (2k) < k), add small[k][ idx%(2k) ].
    for (int k = 1; k <= B; k++) {
        int r = idx % (k << 1);
        if (r < k) ans += smallT[k-1][r];
    }
    return ans;
}

void solve() {
    int q;
    cin >> q;
    segtree st(MAXN);
    while (q--) {
        char type;
        int x;
        cin >> type >> x;
        if (type == '?') {
            cout << query_idx(x - 1, st) << "\n";
        } else {
            x = type == '-' ? -x : x;
            int k;
            cin >> k;
            if (k <= B) {
                for (int r = 0; r < k; r++) {
                    smallT[k-1][r] += x;
                }
            } else {
                int k2 = k << 1;
                for (int i = 0; i < MAXN; i += k2) {
                    st.update(x, i);
                    if (i + k < MAXN)
                        st.update(-x, i + k);
                }
            }
        }
    }
}

signed main() {
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);

    // std::freopen("", "r", stdin);
    // std::freopen("", "w", stdout);

    int t = 1;
    // cin >> t;
    while (t--) solve();
    return 0;
}