#include <bits/stdc++.h>
#include <immintrin.h>
#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,sse4")
using namespace std;

static constexpr int MAXN = 200000;
static constexpr int T    = 450;     // ≈ √MAXN

// “base” array for all large-k updates (applied immediately, AVX2-accelerated)
alignas(32) int a[MAXN];

// small[k][r] accumulates all lazy additions for residue class r mod (2k).
// We only use r=0..k-1 for "add" region. We store in a long long in case sums get big.
static long long smallT[T+1][2*T+2];  // second dim up to 2*T+1

// AVX2 helper: add 'x' to 'length' consecutive ints starting at ptr.
// ptr must be 32-byte aligned. length can be any positive, we do a tail at the end.
inline void add_range_avx(int * __restrict ptr, int length, int x) {
    int i = 0;
    __m256i vx = _mm256_set1_epi32(x);
    // process blocks of 8 ints (256 bits) at a time
    int lim = length & ~7;  // largest multiple of 8 ≤ length
    for (; i < lim; i += 8) {
        __m256i cur = _mm256_load_si256((__m256i*)(ptr + i));
        cur = _mm256_add_epi32(cur, vx);
        _mm256_store_si256((__m256i*)(ptr + i), cur);
    }
    // handle any leftover < 8 ints
    for (; i < length; i++) {
        ptr[i] += x;
    }
}

inline void do_small_update(int k, int x) {
    // k ≤ T. We add 'x' to small[k][0..k−1] (all "active" residues).
    for (int r = 0; r < k; r++) {
        smallT[k][r] += x;
    }
}

inline void do_large_update(int k, int x) {
    // k > T. We explicitly touch each affected block of size k (then skip k).
    int k2 = k << 1;            // 2*k
    // Precompute how many full blocks of size (2k) fit in MAXN:
    int block_count = MAXN / k2;
    int full_bound  = block_count * k2;
    // 1) Handle all full blocks where block size is exactly k:
    for (int i = 0; i < full_bound; i += k2) {
        add_range_avx(a + i, k, x);
    }
    // 2) Handle any “tail” (if MAXN is not a multiple of 2k)
    int rem = MAXN - full_bound;         // rem < 2k
    if (rem > 0) {
        // Add to the first min(k, rem) elements of that final partial block
        int tailSize = (rem < k ? rem : k);
        add_range_avx(a + full_bound, tailSize, x);
    }
}

inline int query_idx(int idx) {
    // idx is 0-based. Start with the base value a[idx].
    long long ans = a[idx];
    // Add all “small-k” contributions: if (idx % (2k) < k), add small[k][ idx%(2k) ].
    for (int k = 1; k <= T; k++) {
        int r = idx % (k << 1); 
        if (r < k) ans += smallT[k][r];
    }
    return (int)ans;  // downcast if you know it fits in int
}

void solve() {
    int q;
    if (scanf("%d", &q) != 1) return;
    // Zero everything (static globals are zeroed by default, but just in case).
    memset(a, 0, sizeof(a));
    for (int k = 1; k <= T; k++) {
        for (int r = 0; r < (2*k); r++) {
            smallT[k][r] = 0;
        }
    }

    while (q--) {
        char type;
        int val;
        scanf(" %c %d", &type, &val);
        if (type == '?') {
            int idx = val - 1; 
            int out = query_idx(idx);
            printf("%d\n", out);
        } else {
            // type is '+' or '-'
            int x = (type == '-') ? -val : +val;
            int k; 
            scanf("%d", &k);
            if (k <= T) {
                do_small_update(k, x);
            } else {
                do_large_update(k, x);
            }
        }
    }
}

int main() {
    // We don’t need iostream at all (we use scanf/printf).
    solve();
    return 0;
}