#include <bits/stdc++.h>

using namespace std;

struct Node {
    long long x, y;
    long long minX, maxX, minY, maxY;
    int prio, sz;
    int lazyRot;
    long long lazyTx, lazyTy;
    Node* l, * r;
    Node(long long _x, long long _y, int _prio)
        : x(_x), y(_y), prio(_prio), sz(1),
        lazyRot(0), lazyTx(0), lazyTy(0),
        l(nullptr), r(nullptr) {
        minX = maxX = x;
        minY = maxY = y;
    }
};

int getsz(Node* t) { return t ? t->sz : 0; }

void pull(Node* t) {
    if (!t) return;
    t->sz = 1 + getsz(t->l) + getsz(t->r);

    t->minX = t->maxX = t->x;
    t->minY = t->maxY = t->y;
    if (t->l) {
        t->minX = min(t->minX, t->l->minX);
        t->maxX = max(t->maxX, t->l->maxX);
        t->minY = min(t->minY, t->l->minY);
        t->maxY = max(t->maxY, t->l->maxY);
    }
    if (t->r) {
        t->minX = min(t->minX, t->r->minX);
        t->maxX = max(t->maxX, t->r->maxX);
        t->minY = min(t->minY, t->r->minY);
        t->maxY = max(t->maxY, t->r->maxY);
    }
}

pair<long long, long long> rotVec(int rot, long long x, long long y) {
    switch (rot & 3) {
    case 0: return { x, y };
    case 1: return { y, -x };
    case 2: return { -x, -y };
    case 3: return { -y, x };
    }
    return { x, y };
}

void applyTransform(Node* t, int rot, long long tx, long long ty) {
    if (!t) return;

    auto [nx, ny] = rotVec(rot, t->x, t->y);
    nx += tx;
    ny += ty;
    t->x = nx;
    t->y = ny;

    long long a = t->minX, b = t->maxX;
    long long c = t->minY, d = t->maxY;
    long long na, nb, nc, nd;
    switch (rot & 3) {
    case 0:
        na = a; nb = b; nc = c; nd = d;
        break;
    case 1:
        na = c;    nb = d;
        nc = -b;   nd = -a;
        break;
    case 2:
        na = -b;   nb = -a;
        nc = -d;   nd = -c;
        break;
    case 3:
        na = -d;   nb = -c;
        nc = a;    nd = b;
        break;
    }
    na += tx; nb += tx;
    nc += ty; nd += ty;
    t->minX = na; t->maxX = nb;
    t->minY = nc; t->maxY = nd;

    int oldRot = t->lazyRot;
    long long oldTx = t->lazyTx, oldTy = t->lazyTy;

    auto [rOldTx, rOldTy] = rotVec(rot, oldTx, oldTy);
    int newRot = (rot + oldRot) & 3;
    long long newTx = rOldTx + tx;
    long long newTy = rOldTy + ty;

    t->lazyRot = newRot;
    t->lazyTx = newTx;
    t->lazyTy = newTy;
}

void push(Node* t) {
    if (!t) return;
    if (t->lazyRot != 0 || t->lazyTx != 0 || t->lazyTy != 0) {
        if (t->l) applyTransform(t->l, t->lazyRot, t->lazyTx, t->lazyTy);
        if (t->r) applyTransform(t->r, t->lazyRot, t->lazyTx, t->lazyTy);
        t->lazyRot = 0;
        t->lazyTx = t->lazyTy = 0;
    }
}

void split(Node* t, Node*& a, Node*& b, int k) {
    if (!t) { a = b = nullptr; return; }
    push(t);
    int leftSz = getsz(t->l);
    if (k <= leftSz) {
        split(t->l, a, t->l, k);
        pull(t);
        b = t;
    }
    else {
        split(t->r, t->r, b, k - leftSz - 1);
        pull(t);
        a = t;
    }
}

Node* merge(Node* a, Node* b) {
    if (!a || !b) return a ? a : b;
    if (a->prio < b->prio) {
        push(a);
        a->r = merge(a->r, b);
        pull(a);
        return a;
    }
    else {
        push(b);
        b->l = merge(a, b->l);
        pull(b);
        return b;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, q; cin >> n >> q;

    mt19937 rng(712367);
    Node* root = nullptr;
    for (int i = 0; i < n; ++i) {
        int x, y;
        cin >> x >> y;
        Node* node = new Node(x, y, (int)rng());
        root = merge(root, node);
    }

    while (q--) {
        int l, r;
        long long cx, cy;
        int angle;
        cin >> l >> r >> cx >> cy >> angle;

        int rot = 0;
        if (angle == 90) rot = 1;
        else if (angle == 180) rot = 2;
        else if (angle == 270) rot = 3;

        auto [rcx, rcy] = rotVec(rot, cx, cy);
        long long tx = cx - rcx;
        long long ty = cy - rcy;

        Node* A, * B, * C;
        split(root, A, B, l - 1);
        split(B, B, C, r - l + 1);

        if (B) applyTransform(B, rot, tx, ty);

        root = merge(A, merge(B, C));

        assert(root->minX >= -1e9 && root->maxX <= 1e9);
        assert(root->minY >= -1e9 && root->maxY <= 1e9);
        long long dx = root->maxX - root->minX;
        long long dy = root->maxY - root->minY;
        long long area = dx * dy;
        cout << area << '\n';
    }
    return 0;
}
