#include "testlib.h"
#include <iostream>

using namespace std;

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int min_n = opt<int>("min_n");
    int max_n = opt<int>("max_n");
    int min_k = opt<int>("min_k");
    int max_k = opt<int>("max_k");
    int min_num = opt<int>("min_num");
    int max_num = opt<int>("max_num");

    int total_n = rnd.next(min_n, max_n);

    vector <pair<int, vector <int>>> tests;
    while (total_n > 0 && tests.size() < 10'000) {
        int n = rnd.next(1, total_n);
        int k = rnd.next(min_k, max_k);
        vector <int> test(n);
        for (int i = 0; i < n; i++) {
            test[i] = rnd.next(min_num, max_num);
        }
        tests.emplace_back(k, test);
        total_n -= n;
    }

    int t = (int)tests.size();
    println(t);
    for (auto [k, test] : tests) {
        int n = (int)test.size();
        println(n, k);
        println(test.begin(), test.end());
    }
    return 0;
}