#include <bits/stdc++.h>
#include "testlib.h"

using namespace std;

int T;
vector<long long> nArr, kArr;

const long long MAXVAL = 1000000000000000000LL; // 1e18

// Несколько простых модулей, часть — "маленькие", часть — около 1e18
const long long MODS[] = {
    1000000007LL,
    1000000009LL,
    1000000021LL,
    1000000033LL,
    1000000087LL,
    1000000093LL,
    1000000097LL,
    1000000103LL,
    1000000123LL,
    1000000181LL,
    1000000207LL,
    1000000223LL,
    1000000000000000003LL,  // ~1e18
    1000000000000000033LL   // ещё один большой
};
const int MODS_CNT = sizeof(MODS) / sizeof(MODS[0]);

long long modPow(long long a, long long e, long long mod) {
    a %= mod;
    long long r = 1 % mod;
    while (e > 0) {
        if (e & 1) r = (long long)((__int128)r * a % mod);
        a = (long long)((__int128)a * a % mod);
        e >>= 1;
    }
    return r;
}

// проверка потока (ans или ouf)
void readAndCheckAnswer(InStream &in, const char *streamName) {
    for (int test = 0; test < T; ++test) {
        long long n = nArr[test];
        long long k = kArr[test];

        // проверка уникальности решений внутри теста
        set<tuple<long long, long long, long long>> used;

        for (long long idx = 0; idx < k; ++idx) {
            long long a = in.readLong(1LL, MAXVAL, "a");
            long long b = in.readLong(1LL, MAXVAL, "b");
            long long c = in.readLong(1LL, MAXVAL, "c");

            auto key = make_tuple(a, b, c);
            if (!used.insert(key).second) {
                in.quitf(_wa,
                         "Duplicate triple (%lld, %lld, %lld) in %s for test %d",
                         a, b, c, streamName, test + 1);
            }

            // проверяем уравнение по нескольким модулям
            for (int i = 0; i < MODS_CNT; ++i) {
                long long mod = MODS[i];

                long long an  = modPow(a, n,     mod);
                long long bn  = modPow(b, n,     mod);
                long long cn1 = modPow(c, n + 1, mod);

                long long lhs = an + bn;
                if (lhs >= mod) lhs -= mod;

                if (lhs != cn1) {
                    in.quitf(_wa,
                             "Equation does not hold modulo %lld for triple (%lld, %lld, %lld) in %s for test %d",
                             mod, a, b, c, streamName, test + 1);
                }
            }
        }
    }
}

int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);

    T = inf.readInt();
    nArr.resize(T);
    kArr.resize(T);
    for (int i = 0; i < T; ++i) {
        nArr[i] = inf.readLong();
        kArr[i] = inf.readLong();
    }

    readAndCheckAnswer(ans, "jury output");
    readAndCheckAnswer(ouf, "participant output");

    quitf(_ok, "t=%d", T);
}
