#include <bits/stdc++.h>
using namespace std;

void fwht(vector<long long>& a, bool invert) {
    int n = (int)a.size();
    for (int len = 1; len < n; len <<= 1) {
        for (int i = 0; i < n; i += (len << 1)) {
            for (int j = 0; j < len; ++j) {
                long long u = a[i + j];
                long long v = a[i + j + len];
                a[i + j] = u + v;
                a[i + j + len] = u - v;
            }
        }
    }
    if (invert) {
        for (int i = 0; i < n; ++i)
            a[i] /= n;  // все значения кратны n
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;

    vector<vector<pair<int,int>>> g(n + 1);
    for (int i = 0; i < n - 1; ++i) {
        int u, v, w;
        cin >> u >> v >> w;
        g[u].push_back({v, w});
        g[v].push_back({u, w});
    }

    // 1. Считаем pref[v] = XOR от корня (1) до v
    vector<int> pref(n + 1, 0);
    vector<char> used(n + 1, 0);
    vector<int> st;
    st.reserve(n);
    st.push_back(1);
    used[1] = 1;

    while (!st.empty()) {
        int v = st.back();
        st.pop_back();
        for (auto &edge : g[v]) {
            int to = edge.first;
            int w  = edge.second;
            if (!used[to]) {
                used[to] = 1;
                pref[to] = pref[v] ^ w;
                st.push_back(to);
            }
        }
    }

    int q;
    cin >> q;
    vector<int> F(q);
    int maxVal = 0;
    for (int i = 0; i < q; ++i) {
        cin >> F[i];
        if (F[i] > maxVal) maxVal = F[i];
    }
    for (int i = 1; i <= n; ++i)
        if (pref[i] > maxVal) maxVal = pref[i];

    // Размер массива для FWHT: ближайшая степень двойки >= maxVal+1
    int K = 0;
    while ((1 << K) <= maxVal) ++K;
    if (K == 0) K = 1;  // хотя бы 1
    int M = 1 << K;

    // 2. Считаем частоты prefix XOR
    vector<long long> a(M, 0);
    for (int i = 1; i <= n; ++i)
        a[pref[i]]++;

    // 3. XOR-свёртка cnt с самим собой через FWHT
    fwht(a, false);        // прямое преобразование
    for (int i = 0; i < M; ++i)
        a[i] *= a[i];      // поэлементное умножение (свёртка с самим собой)
    fwht(a, true);         // обратное преобразование

    // Теперь a[f] = ans2[f] — число упорядоченных пар (u, v) с pref[u]^pref[v] = f
    vector<long long> ans(M, 0);
    ans[0] = (a[0] - n) / 2;   // убираем пары (v, v) и делим на 2
    for (int f = 1; f < M; ++f)
        ans[f] = a[f] / 2;     // каждая пара считается дважды

    // 4. Отвечаем на запросы
    for (int i = 0; i < q; ++i) {
        cout << ans[F[i]] << '\n';
    }

    return 0;
}
