#include <bits/stdc++.h>

using namespace std;

const int MAXM = 200005;

struct Fenwick {
    int n;
    vector<int> f;

    Fenwick(int _n) : n(_n), f(n + 1, 0) {}

    void upd(int i, int v) {
        for (; i <= n; i += i & -i) {
            f[i] += v;
        }
    }

    void range_add(int l, int r, int v) {
        if (l > r) return;
        upd(l, v);
        if (r + 1 <= n) upd(r + 1, -v);
    }

    int query(int i) const {
        int s = 0;
        for (; i > 0; i -= i & -i) {
            s += f[i];
        }
        return s;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t= 1;

    int B = 1000;
    vector<int> S(B, 0);

    while (t--) {
        int q;
        cin >> q;

        fill(S.begin(), S.end(), 0);

        Fenwick bit(MAXM + 2);

        while (q--) {
            char op;
            cin >> op;
            if (op == '+' || op == '-') {
                int x;
                int k;
                cin >> x >> k;
                int sign = (op == '+' ? 1 : -1);

                if (k < B) {
                    S[k] += sign * x;
                } else {
                    int cycle = 2 * k;
                    for (int start = 1; start <= MAXM; start += cycle) {
                        int l = start;
                        int r = start + k - 1;
                        if (r > MAXM) r = MAXM;
                        bit.range_add(l, r, sign * x);
                    }
                }
            } else if (op == '?') {
                int ti;
                cin >> ti;
                int ans = bit.query(ti);
                int d;
                for (int k = 1; k < B; k++) {
                    if (S[k] == 0) continue;
                    d = (ti - 1) % (2 * k);
                    if (d < k) {
                        ans += S[k];
                    }
                }
                cout << ans << "\n";
            }
        }
    }
}
