#include <bits/stdc++.h>

using namespace std;

const int MAXM = 200005;
const int B = 800;

struct SegmentTree {
    int n;
    vector<long long> tree;

    SegmentTree(int _n) {
        n = _n;
        tree.assign(4 * n + 4, 0);
    }

    void point_update(int node, int l, int r, int pos, int val) {
        if (l == r) {
            tree[node] += val;
            return;
        }
        int mid = (l + r) >> 1;
        if (pos <= mid) {
            point_update(node<<1, l, mid, pos, val);
        } else {
            point_update(node<<1|1, mid+1, r, pos, val);
        }
        tree[node] = tree[node<<1] + tree[node<<1|1];
    }

    long long range_query(int node, int l, int r, int ql, int qr) const {
        if (qr < l || r < ql) return 0;
        if (ql <= l && r <= qr) {
            return tree[node];
        }
        int mid = (l + r) >> 1;
        return range_query(node<<1, l, mid, ql, qr)
             + range_query(node<<1|1, mid+1, r, ql, qr);
    }

    void update(int pos, int val) {
        if (pos < 1 || pos > n) return;
        point_update(1, 1, n, pos, val);
    }

    long long query_prefix(int pos) const {
        if (pos < 1) return 0;
        if (pos > n) pos = n;
        return range_query(1, 1, n, 1, pos);
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t = 1;
    while (t--) {
        int q;
        cin >> q;

        vector<long long> S(B, 0);
        SegmentTree seg(MAXM + 2);

        while (q--) {
            char op;
            cin >> op;
            if (op == '+' || op == '-') {
                int x, k;
                cin >> x >> k;
                int sign = (op == '+') ? 1 : -1;

                if (k < B) {
                    S[k] += sign * x;
                } else {
                    int cycle = 2 * k;
                    for (int start = 1; start <= MAXM; start += cycle) {
                        int l = start;
                        int r = start + k - 1;
                        if (r > MAXM) r = MAXM;
                        seg.update(l, sign * x);
                        seg.update(r + 1, -sign * x);
                    }
                }
            } else if (op == '?') {
                int ti;
                cin >> ti;
                long long ans = seg.query_prefix(ti);
                for (int k = 1; k < B; k++) {
                    if (S[k] == 0) continue;
                    int d = (ti - 1) % (2 * k);
                    if (d < k) {
                        ans += S[k];
                    }
                }
                cout << ans << "\n";
            }
        }
    }

    return 0;
}
