#include <iostream>
#include <vector>
#include <algorithm>
#include <bitset>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_set>
#include <cstddef>
#include <unordered_map>
#include <array>
#include <forward_list>
#include <list>
#include <ranges>
#include <functional>
#include <variant>
#include <version>

#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,popcnt,lzcnt,abm,bmi,bmi2")


#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#ifdef DUDE
#define debug(x) cerr << #x << ": " << x << endl
#define debugvec(x) ({cerr << #x << ":\n"; for (const auto& e :x) cerr << '\t' << e << '\n';})
#else
#define debug(x) ;
#define debugvec(x) ;
#endif

using std::cout;
using std::cin;
using std::cerr;
using std::endl;
using std::ostream;
using std::istream;
using std::vector;
using std::pair;
using std::string;
using std::array;
using std::tuple;

using ll = long long;
using ull = unsigned long long;
using ld = long double;
using uint = unsigned int;
std::mt19937 rnd(459);


template<typename T, typename U>
istream &operator>>(istream &in, std::pair<T, U> &p) {
    in >> p.first >> p.second;
    return in;
}

template<typename... T>
istream &operator>>(istream &in, tuple<T...> &p) {
    [&]<size_t... idx>(std::index_sequence<idx...>) {
        (in >> ... >> get<idx>(p));
    }(std::make_index_sequence<sizeof...(T)>());
    return in;
}

template<typename T>
istream &operator>>(istream &in, vector<T> &vec) {
    for (size_t i = 0; i < vec.size(); ++i) {
        in >> vec[i];
    }
    return in;
}

ostream &operator<<(ostream &out, const vector<bool> &vec) {
    for (bool i: vec) {
        if (i)
            out << '1';
        else
            out << '0';
    }
    return out;
}

ostream &operator<<(ostream &out, __int128 x) {
    constexpr ll BASE = 1'000'000'000'000'000'000;
    if (x < BASE) {
        out << static_cast<ll>(x);
        return out;
    }
    out << static_cast<ll>(x / BASE) << std::setw(18) << std::setfill('0') << static_cast<ll>(x % BASE) << std::setw(0);
    return out;
}

template<typename T, typename U>
ostream &operator<<(ostream &out, const pair<T, U> &p) {
    out << p.first << ' ' << p.second;
    return out;
}


template<typename... T>
ostream &operator<<(ostream &out, const tuple<T...> &p) {
    [&]<size_t... idx>(std::index_sequence<idx...>) {
        (out << ... << get<idx>(p));
    }(std::make_index_sequence<sizeof...(T)>());
    return out;
}

struct int_mod;

namespace std {
    template<>
    struct is_arithmetic<int_mod> : std::true_type {
    };
}

int_mod power(int_mod a, size_t n);

struct int_mod {
    static constexpr int MOD = 998'244'353;

    int x;

    int_mod() : x(0) {
    }

    int_mod(ll x): x(x) {
    }

    int_mod &operator =(int_mod other) {
        x = other.x;
        return *this;
    }

    friend istream &operator >>(istream &in, int_mod &a) {
        in >> a.x;
        return in;
    }

    friend ostream &operator <<(ostream &out, const int_mod &a) {
        out << a.x;
        return out;
    }

    int_mod &operator +=(int_mod other) {
        x += other.x;
        if (x >= MOD) {
            x -= MOD;
        }
        return *this;
    }

    int_mod &operator -=(int_mod other) {
        x -= other.x;
        if (x < 0) {
            x += MOD;
        }
        return *this;
    }

    int_mod &operator *=(int_mod other) {
        x = static_cast<int>((static_cast<ll>(x) * other.x) % MOD);
        return *this;
    }

    int_mod inv() const {
        return power(*this, MOD - 2);
    }

    int_mod &operator /=(int_mod other) {
        *this = *this / other;
        return *this;
    }

    friend int_mod operator +(int_mod a, int_mod b) {
        int_mod res = a;
        res += b;
        return res;
    }

    friend int_mod operator -(int_mod a, int_mod b) {
        int_mod res = a;
        res -= b;
        return res;
    }

    friend int_mod operator *(int_mod a, int_mod b) {
        int_mod res = a;
        res *= b;
        return res;
    }

    friend int_mod operator /(int_mod a, int_mod b) {
        return a * b.inv();
    }

    operator int() const {
        return x;
    }
};


int_mod power(int_mod a, size_t n) {
    if (n == 0) {
        return 1;
    }
    if (n == 1) {
        return a;
    }
    int_mod b = power(a, n >> 1);
    if (n % 2 == 0) {
        return b * b;
    }
    return b * b * a;
}

template<std::ranges::forward_range T>
    requires(!std::is_convertible_v<T, string>)
ostream &operator<<(ostream &out, const T &vec) {
    char end_char = '\n';
    if constexpr (std::is_arithmetic_v<typename T::value_type>)
        end_char = ' ';
    for (const auto &e: vec)
        out << e << end_char;
    return out;
}


template<typename T, size_t N>
    requires (!std::is_same_v<T, char>)
ostream &operator <<(ostream &out, const T (&a)[N]) {
    char end_char = '\n';
    if constexpr (std::is_arithmetic_v<T>)
        end_char = ' ';
    for (int i = 0; i < N; ++i) {
        out << a[i] << end_char;
    }
    return out;
}

template<typename T, typename U>
bool mini(T &a, const U &b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T, typename U>
bool maxi(T &a, const U &b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

/*
 *
 */


constexpr int N = 2e5;
int a[N];

void solve() {
    int q;
    cin >> q;
    while (q--) {
        char t;
        cin >> t;
        if (t == '?') {
            int x;
            cin >> x;
            cout << a[x - 1] << '\n';
        }  else {
            int x, k;
            cin >> x >> k;
            int k2 = 2 * k;
            if (t == '-') {
                x = -x;
            }
            for (int s = 0; s < N; s += k2) {
                int end = std::min(s + k, N);
                for (int i = s; i < end; ++i) {
                    a[i] += x;
                }
            }
        }
    }
}

signed main() {
    // stress();

    //
    // return 0;

    std::ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

#ifdef DUDE
    freopen("./../inputf.in", "r", stdin);
    freopen("./../outputf.out", "w", stdout);
#else
    // freopen("./check.in", "r", stdin);
    // freopen("./check.out", "w", stdout);
#endif

    // #define DUDE
    int test = 1;
#ifdef DUDE
    cin >> test;
#endif
    while (test--) {
        solve();
        cout << '\n';
    }
    return 0;
};