#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;

int randomAngle() {
    static int A[3] = {90, 180, 270};
    return A[rnd.next(0, 2)];
}

pair<int,int> randomSegment(int n) {
    int l = rnd.next(1, n);
    int r = rnd.next(1, n);
    if (l > r) swap(l, r);
    return {l, r};
}

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);

    int n = opt<int>(1);
    int q = opt<int>(2);
    int type = opt<int>(3, 1);

    int B = int(1000000000LL / (2LL * q + 1));
    if (B > 100000000) B = 100000000;
    if (B < 1) B = 1;

    cout << n << " " << q << "\n";

    vector<long long> x(n), y(n);

    if (type == 1) {
        for (int i = 0; i < n; ++i) {
            x[i] = rnd.next(-min(B, 1000), min(B, 1000));
            y[i] = rnd.next(-min(B, 1000), min(B, 1000));
        }
    } else if (type == 3) {
        long long fy = rnd.next(-B, B);
        for (int i = 0; i < n; ++i) {
            x[i] = rnd.next(-B, B);
            y[i] = fy;
        }
    } else if (type == 4) {
        int clusters = min(n, 5);
        vector<pair<long long,long long>> c(clusters);
        for (int i = 0; i < clusters; ++i) {
            c[i].first  = rnd.next(-B / 2, B / 2);
            c[i].second = rnd.next(-B / 2, B / 2);
        }
        for (int i = 0; i < n; ++i) {
            int id = rnd.next(0, clusters - 1);
            long long dx = rnd.next(-B / 2, B / 2);
            long long dy = rnd.next(-B / 2, B / 2);
            x[i] = c[id].first  + dx;
            y[i] = c[id].second + dy;
            if (x[i] < -B) x[i] = -B;
            if (x[i] >  B) x[i] =  B;
            if (y[i] < -B) y[i] = -B;
            if (y[i] >  B) y[i] =  B;
        }
    } else if (type == 5) {
        int p1 = n / 3;
        int p2 = n / 3;
        int p3 = n - p1 - p2;

        for (int i = 0; i < p1; ++i) {
            x[i] = rnd.next(-B, B);
            y[i] = rnd.next(-B, B);
        }

        long long fx = rnd.next(-B, B);
        long long fy = rnd.next(-B, B);
        for (int i = p1; i < p1 + p2; ++i) {
            if (rnd.next(0, 1) == 0) {
                x[i] = fx;
                y[i] = rnd.next(-B, B);
            } else {
                x[i] = rnd.next(-B, B);
                y[i] = fy;
            }
        }

        int clusters = min(p3, 3);
        vector<pair<long long,long long>> c(clusters);
        for (int i = 0; i < clusters; ++i) {
            c[i].first  = rnd.next(-B / 2, B / 2);
            c[i].second = rnd.next(-B / 2, B / 2);
        }
        for (int i = p1 + p2; i < n; ++i) {
            int id = rnd.next(0, clusters - 1);
            long long dx = rnd.next(-B / 2, B / 2);
            long long dy = rnd.next(-B / 2, B / 2);
            x[i] = c[id].first  + dx;
            y[i] = c[id].second + dy;
            if (x[i] < -B) x[i] = -B;
            if (x[i] >  B) x[i] =  B;
            if (y[i] < -B) y[i] = -B;
            if (y[i] >  B) y[i] =  B;
        }
    } else {
        for (int i = 0; i < n; ++i) {
            x[i] = rnd.next(-B, B);
            y[i] = rnd.next(-B, B);
        }
    }

    for (int i = 0; i < n; ++i)
        cout << x[i] << " " << y[i] << "\n";

    for (int i = 0; i < q; ++i) {
        int l, r;
        long long cx, cy;
        int ang = randomAngle();

        if (type == 3) {
            if (rnd.next(0, 4) == 0) {
                tie(l, r) = randomSegment(n);
            } else {
                l = 1; r = n;
            }
            cx = rnd.next(-B, B);
            cy = rnd.next(-B, B);
        } else if (type == 4) {
            if (rnd.next(0, 4) == 0) {
                tie(l, r) = randomSegment(n);
            } else {
                l = r = rnd.next(1, n);
            }
            int id = l - 1;
            cx = x[id] + rnd.next(-min(B, 1000), min(B, 1000));
            cy = y[id] + rnd.next(-min(B, 1000), min(B, 1000));
            if (cx < -B) cx = -B;
            if (cx >  B) cx =  B;
            if (cy < -B) cy = -B;
            if (cy >  B) cy =  B;
        } else if (type == 5) {
            int mode = rnd.next(0, 2);
            if (mode == 0) {
                l = rnd.next(1, n);
                int len = rnd.wnext(1, min(n - l + 1, 20), -3);
                r = l + len - 1;
            } else {
                if (rnd.next(0, 5) == 0) {
                    l = 1; r = n;
                } else {
                    tie(l, r) = randomSegment(n);
                }
            }

            int cm = rnd.next(0, 2);
            if (cm == 0) {
                cx = 0;
                cy = 0;
            } else if (cm == 1) {
                int id = rnd.next(0, n - 1);
                cx = x[id];
                cy = y[id];
            } else {
                cx = rnd.next(-B, B);
                cy = rnd.next(-B, B);
            }
        } else if (type == 1) {
            l = rnd.next(1, n);
            int len = rnd.next(1, min(n - l + 1, 5));
            r = l + len - 1;
            cx = rnd.next(-min(B, 1000), min(B, 1000));
            cy = rnd.next(-min(B, 1000), min(B, 1000));
        } else {
            tie(l, r) = randomSegment(n);
            cx = rnd.next(-B, B);
            cy = rnd.next(-B, B);
        }

        cout << l << " " << r << " " << cx << " " << cy << " " << ang << "\n";
    }

    return 0;
}
