#include <bits/stdc++.h>
#define int i64

using namespace std;
using i64 = int64_t;

struct SegTreeNode {
    struct Node {
        int mn, mx, offset;
        bool inv;

        Node(int v) {
            mn = v;
            mx = v;
            offset = 0;
            inv=false;
        }

        Node(const Node& a, const Node& b) {
            mn = min(a.mn, b.mn);
            mx = max(a.mx, b.mx);
            offset = 0;
            inv = false;
        }
    };

    Node v;
    SegTreeNode *lc, *rc;

    SegTreeNode(int v) : v(v) {
        lc = rc = nullptr;
    }

    SegTreeNode(SegTreeNode* l, SegTreeNode* r): v(l->v, r->v) {
        lc = l;
        rc = r;
    }

    void push() {
        if (v.inv) {
            lc->v.mn *= -1;
            lc->v.mx *= -1;
            ::swap(lc->v.mn, lc->v.mx);
            rc->v.mn *= -1;
            rc->v.mx *= -1;
            ::swap(rc->v.mn, rc->v.mx);

            lc->v.offset = -lc->v.offset;
            rc->v.offset = -rc->v.offset;
            lc->v.inv ^= 1;
            rc->v.inv ^= 1;
        }
        if (v.offset) {
            lc->v.offset += v.offset;
            rc->v.offset += v.offset;
            lc->v.mn += v.offset;
            lc->v.mx += v.offset;
            rc->v.mn += v.offset;
            rc->v.mx += v.offset;
        }
        v.inv = 0;
        v.offset = 0;
    }

    void add(int l, int r, int ql, int qr, int x) {
        if (r <= ql || qr <= l) return;
        if (ql <= l && r <= qr) {
            v.mn += x;
            v.mx += x;
            v.offset += x;
            return;
        }
        push();
        int m = (l + r) / 2;
        lc->add(l, m, ql, qr, x);
        rc->add(m, r, ql, qr, x);
        v = Node(lc->v, rc->v);
    }

    void inv(int l, int r, int ql, int qr) {
        if (r <= ql || qr <= l) return;
        if (ql <= l && r <= qr) {
            ::swap(v.mn, v.mx);
            v.mn = -v.mn;
            v.mx = -v.mx;
            v.offset = -v.offset;
            v.inv ^= 1;
            return;
        }
        push();
        int m = (l + r) / 2;
        lc->inv(l, m, ql, qr);
        rc->inv(m, r, ql, qr);
        v = Node(lc->v, rc->v);
    }

    int getmin(int l, int r, int ql, int qr) {
        if (qr <= l || r <= ql) return INT_MAX;
        if (ql <= l && r <= qr) return v.mn;
        push();
        int m = (l + r) / 2;
        return min(lc->getmin(l, m, ql, qr), rc->getmin(m, r, ql, qr));
    }

    int getmax(int l, int r, int ql, int qr) {
        if (qr <= l || r <= ql) return INT_MIN;
        if (ql <= l && r <= qr) return v.mx;
        push();
        int m = (l + r) / 2;
        return max(lc->getmax(l, m, ql, qr), rc->getmax(m, r, ql, qr));
    }

    static pair<SegTreeNode*, SegTreeNode*> swap(SegTreeNode* lt, SegTreeNode* rt, int l, int r, int ql, int qr) {
        if (r <= ql || qr <= l) return {lt, rt};
        if (ql <= l && r <= qr) return {rt, lt};
        lt->push();
        rt->push();
        int m = (l + r) / 2;
        auto [llc, lrc] = swap(lt->lc, rt->lc, l, m, ql, qr);
        auto [rlc, rrc] = swap(lt->rc, rt->rc, m, r, ql, qr);
        lt->lc = llc;
        lt->rc = rlc;
        lt->v = Node(llc->v, rlc->v);
        rt->lc = lrc;
        rt->rc = rrc;
        rt->v = Node(lrc->v, rrc->v);
        return {lt, rt};
    }

    static SegTreeNode* build(int l, int r, const vector<int>& v) {
        if (l + 1 == r) {
            return new SegTreeNode(v[l]);
        }
        int m = (l + r) / 2;
        return new SegTreeNode(build(l, m, v), build(m, r, v));
    }
    void print(int l, int r) {
        if (l + 1 == r) {
            cout << v.mn << " ";
        } else {
            push();
            int m = (l + r) / 2;
            lc->print(l, m);
            rc->print(m, r);
        }
    }
};

signed main() {
    int n, q;
    cin >> n >> q;

    vector<int> pointsx(n), pointsy(n);
    for (int i = 0; i < n; i++) {
        cin >> pointsx[i] >> pointsy[i];
    }

    SegTreeNode* xtree = SegTreeNode::build(0, n, pointsx);
    SegTreeNode* ytree = SegTreeNode::build(0, n, pointsy);
    while (q--) {
        int l, r, x, y, a;
        cin >> l >> r >> x >> y >> a;
        l--;
        xtree->add(0, n, l, r, -x);
        ytree->add(0, n, l, r, -y);

        if (a == 270) {
            ytree->inv(0, n, l, r);
            SegTreeNode::swap(xtree, ytree, 0, n, l, r);
        } else if (a == 180) {
            xtree->inv(0, n, l, r);
            ytree->inv(0, n, l, r);
        } else if (a == 90) {
            xtree->inv(0, n, l, r);
            SegTreeNode::swap(xtree, ytree, 0, n, l, r);
        }

        xtree->add(0, n, l, r, x);
        ytree->add(0, n, l, r, y);

        int mnx = xtree->getmin(0, n, 0, n);
        int mxx = xtree->getmax(0, n, 0, n);
        int mny = ytree->getmin(0, n, 0, n);
        int mxy = ytree->getmax(0, n, 0, n);

        cout << 1ll * (mxx - mnx) * (mxy - mny) << endl;

        // cout << "X: ";
        // xtree->print(0, n);
        // cout << "\n";
        // cout << "Y: ";
        // ytree->print(0, n);
        // cout << "\n";
    }
}

/*
2 1
0 1
1 0
1 1 0 0 90

*/