#include "testlib.h"
#include "constants.h"

using namespace std;

using ll = long long;

template<typename T>
T get_opt(const string &key, const T &def) {
    return has_opt(key) ? opt<T>(key) : def;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int n = get_opt<int>("n", constants::MAX_N);
    int q = get_opt<int>("q", constants::MAX_Q);

    n = max(1, min(n, constants::MAX_N));
    q = max(1, min(q, constants::MAX_Q));

    vector<int> a(n, 1);

    vector<ll> pref(n + 1, 0);
    for (int i = 0; i < n; ++i) {
        pref[i + 1] = pref[i] + a[i];
    }

    cout << n << ' ' << q << '\n';
    for (int i = 0; i < n; ++i) {
        if (i) cout << ' ';
        cout << a[i];
    }
    cout << '\n';

    auto makeS = [&](ll sum, int type) -> ll {
        ll S;
        if (type == 0) {
            S = sum;
        } else if (type == 1) {
            ll maxDelta = constants::MAX_S - sum;
            if (maxDelta <= 0) {
                S = constants::MAX_S;
            } else {
                ll delta = rnd.next(1LL, maxDelta);
                S = sum + delta;
            }
        } else {
            if (sum <= 1) {
                S = sum;
            } else {
                ll maxDelta = sum - 1;
                ll delta = rnd.next(1LL, maxDelta);
                S = sum - delta;
            }
        }
        if (S < 1) S = 1;
        if (S > constants::MAX_S) S = constants::MAX_S;
        return S;
    };

    for (int qi = 0; qi < q; ++qi) {
        int l = rnd.next(1, n);
        int r = rnd.next(1, n);
        if (l > r) swap(l, r);

        ll segSum = pref[r] - pref[l - 1];

        int type;
        if (qi == 0) {
            type = 0;
        } else if (qi == 1 && q >= 2) {
            type = 1;
        } else if (qi == 2 && q >= 3) {
            type = 2;
        } else {
            int roll = rnd.next(0, 99);
            if (roll < 50) type = 0;
            else if (roll < 95) type = 1;
            else type = 2;
        }

        ll S = makeS(segSum, type);
        cout << l << ' ' << r << ' ' << S << '\n';
    }

    return 0;
}
