#include <bits/stdc++.h>
#include "testlib.h"

using namespace std;

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    // 1) n, k
    int n = inf.readInt(1, 100000, "n");
    inf.readSpace();
    long long k = inf.readLong(1LL, 1000000000LL, "k");
    inf.readEoln();

    // 2) n слов, только [a-z], 1 <= |s|, sum |s| <= 1e6
    long long sumLen = 0;
    for (int i = 0; i < n; ++i) {
        string s = inf.readToken("[a-z]+", "s");
        inf.readEoln();
        sumLen += (int)s.size();
        inf.ensuref(sumLen <= 1000000,
                    "Sum of lengths of all words must be at most 10^6");
    }

    // 3) три строки клавиатуры, каждая длины ровно 9 символов
    string r1 = inf.readLine();
    string r2 = inf.readLine();
    string r3 = inf.readLine();

    inf.ensuref((int)r1.size() == 9, "First keyboard row must have length 9");
    inf.ensuref((int)r2.size() == 9, "Second keyboard row must have length 9");
    inf.ensuref((int)r3.size() == 9, "Third keyboard row must have length 9");

    // координаты пробела: третья строка, пятый столбец (индекс 4)
    inf.ensuref(r3[4] == ' ', "Space must be at position (3,5) of the keyboard");

    // 4) проверяем, что на клавиатуре ровно 1 пробел и 26 разных букв a..z
    string all = r1 + r2 + r3;
    inf.ensuref((int)all.size() == 27,
                "Keyboard must consist of 27 characters in total (26 letters + space)");

    int spaceCnt = 0;
    bool used[26] = {false};

    for (char c : all) {
        if (c == ' ') {
            ++spaceCnt;
        } else {
            inf.ensuref('a' <= c && c <= 'z',
                        "Keyboard characters must be lowercase latin letters or space");
            int id = c - 'a';
            inf.ensuref(!used[id],
                        "Each letter on keyboard must be unique");
            used[id] = true;
        }
    }

    inf.ensuref(spaceCnt == 1, "Keyboard must contain exactly one space");
    for (int i = 0; i < 26; ++i) {
        inf.ensuref(used[i],
                    "Keyboard must contain each letter from 'a' to 'z' exactly once");
    }

    inf.readEof();
    return 0;
}
