#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;

// Раскладка фиксирована, как в условии:
// abcdefghi
// jklmnopqr
// stuv wxyz

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int n        = opt<int>(1);              // количество слов
    long long k  = opt<long long>(2);        // сколько слов нужно напечатать
    int sumLimit = opt<int>(3, 1000000);     // лимит на суммарную длину (по желанию)

    if (n < 26) n = 26;
    sumLimit = min(sumLimit, 1000000);

    cout << n << ' ' << k << '\n';

    vector<string> words;
    words.reserve(n);
    long long totalLen = 0;

    // ---------- 1. Специальный цикл из 26 слов длиной >= 3 ----------
    // порядок букв по клавиатуре (без пробела)
    string order = "abcdefghijrqponmlkstuvwxyz";
    string letters;
    for (char c : order)
        if (c != ' ')
            letters += c; // 26 букв

    for (int i = 0; i < 26; ++i) {
        char c1 = letters[i];
        char c2 = letters[(i + 1) % 26];

        int len = rnd.next(3, 8);      // длина слова от 3 до 8
        string s(len, c1);
        s[0] = c1;
        for (int j = 1; j < len - 1; ++j)
            s[j] = c1;                 // повторяем первую букву
        s[len - 1] = c2;               // последняя — следующая буква цикла

        words.push_back(s);
        totalLen += len;
    }

    // ---------- 2. Остальные слова — случайные "шумовые" ----------
    while ((int)words.size() < n) {
        int leftWords = n - (int)words.size();

        int minNeed = 2 * leftWords;              // каждому хотя бы по 2
        int leftLen = sumLimit - (int)totalLen;
        if (leftLen < minNeed) leftLen = minNeed;

        int maxLenForThis = leftLen - 2 * (leftWords - 1);
        maxLenForThis = max(2, min(maxLenForThis, 25));

        int len = rnd.next(2, maxLenForThis);
        string s(len, 'a');

        s[0] = char('a' + rnd.next(0, 25));
        for (int i = 1; i < len; ++i) {
            char prev = s[i - 1];
            char c;
            do {
                c = char('a' + rnd.next(0, 25));
            } while (c == prev);
            s[i] = c;
        }
        if (s.back() == s.front()) {
            char forbid = s.front();
            char c;
            do {
                c = char('a' + rnd.next(0, 25));
            } while (c == forbid || (len > 1 && c == s[len - 2]));
            s.back() = c;
        }

        words.push_back(s);
        totalLen += len;
    }

    shuffle(words.begin(), words.end());
    // ---------- выводим слова ----------
    for (const string &s : words)
        cout << s << '\n';

    // ---------- выводим раскладку ----------
    cout << "abcdefghi\n";
    cout << "jklmnopqr\n";
    cout << "stuv wxyz\n";

    return 0;
}
