#include <bits/stdc++.h>
using namespace std;

const long long INF = (long long)4e18;
const int A = 26; // буквы 'a'..'z'

using Matrix = array<array<long long, A>, A>;

Matrix combine(const Matrix &L, const Matrix &R,
               const long long dist[A][A]) {
    Matrix C;
    for (int i = 0; i < A; ++i)
        for (int j = 0; j < A; ++j)
            C[i][j] = INF;

    for (int x = 0; x < A; ++x) {
        for (int y = 0; y < A; ++y) {
            long long dxy = dist[x][y];
            if (dxy >= INF) continue;
            for (int i = 0; i < A; ++i) {
                long long left = L[i][x];
                if (left >= INF) continue;
                long long base = left + dxy;
                if (base >= INF) continue;
                for (int j = 0; j < A; ++j) {
                    long long right = R[y][j];
                    if (right >= INF) continue;
                    long long val = base + right;
                    if (val < C[i][j]) C[i][j] = val;
                }
            }
        }
    }
    return C;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    long long k;
    if (!(cin >> n >> k)) return 0;

    vector<string> words(n);
    for (int i = 0; i < n; ++i) cin >> words[i];

    int x[A], y[A];
    for (int i = 0; i < A; ++i) x[i] = y[i] = -1;

    for (int row = 0; row < 3; ++row) {
        string line;
        cin >> ws;
        getline(cin, line);
        for (int col = 0; col < 9; ++col) {
            char ch = line[col];
            if (ch == ' ') continue;
            int id = ch - 'a';
            x[id] = row;
            y[id] = col;
        }
    }

    long long dist[A][A];
    for (int i = 0; i < A; ++i)
        for (int j = 0; j < A; ++j)
            dist[i][j] = llabs(x[i] - x[j]) + llabs(y[i] - y[j]);

    Matrix opt;
    for (int i = 0; i < A; ++i)
        for (int j = 0; j < A; ++j)
            opt[i][j] = INF;

    for (const string &s : words) {
        if (s.empty()) continue;
        int first = s.front() - 'a';
        int last  = s.back()  - 'a';
        long long cost = 0;
        for (int i = 1; i < (int)s.size(); ++i) {
            int u = s[i-1] - 'a';
            int v = s[i]   - 'a';
            cost += dist[u][v];
            if (cost >= INF) { cost = INF; break; }
        }
        opt[first][last] = min(opt[first][last], cost);
    }

    const int LOGK = 32;
    vector<Matrix> pw(LOGK);
    pw[0] = opt;
    for (int p = 1; p < LOGK; ++p)
        pw[p] = combine(pw[p-1], pw[p-1], dist);

    Matrix res;
    bool hasRes = false;
    for (int p = 0; p < LOGK; ++p) {
        if ((k >> p) & 1LL) {
            if (!hasRes) {
                res = pw[p];
                hasRes = true;
            } else {
                res = combine(res, pw[p], dist);
            }
        }
    }

    long long ans = INF;
    if (hasRes) {
        for (int i = 0; i < A; ++i)
            for (int j = 0; j < A; ++j)
                ans = min(ans, res[i][j]);
    }

    if (ans >= INF) ans = -1;
    cout << ans << '\n';
    return 0;
}
